/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.config.ConversionRegistry;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackTagMatcher
extends ItemStackMatcher {
    private List<ItemStack> tagMatches;

    public ItemStackTagMatcher(ItemStack stack) {
        super(stack);
        this.refreshTagMatches();
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (!ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)stack)) {
            if (this.tagMatches == null) {
                return false;
            }
            if (this.stack.m_41720_() == stack.m_41720_()) {
                return false;
            }
            boolean tagMatch = false;
            for (ItemStack tagStack : this.tagMatches) {
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)tagStack)) continue;
                tagMatch = true;
                break;
            }
            return tagMatch;
        }
        return ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)stack);
    }

    public void refreshTagMatches() {
        if (this.stack.m_41619_()) {
            this.tagMatches = null;
            return;
        }
        this.tagMatches = ConversionRegistry.INSTANCE.getEquivItems(this.stack.m_41720_());
        List tags = this.stack.m_204131_().toList();
        for (TagKey tag : tags) {
            if (!ConversionRegistry.INSTANCE.isEntryValid((TagKey<Item>)tag)) continue;
            BuiltInRegistries.f_257033_.m_203561_(tag).m_203614_().forEach(e -> this.tagMatches.add(new ItemStack(e)));
        }
        if (this.tagMatches.isEmpty()) {
            this.tagMatches = null;
        }
    }
}

